class Ex5_15
parameter Real p4_by_p1=6;/*pressure ratio for process 1-4*/
parameter Real p6_by_p9=6;/*pressure ratio for process 6-9*/
parameter Real T1_degC(unit="degC")=15;/*temperature at inlet in degree cencius*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T6_degC(unit="degC")=750;/*temperature at stage 6 in degree cencius*/
Real T6(unit="K");/*temperature at stage 6 in degree kelvin unit*/
parameter Real T8_degC(unit="degC")=750;/*temperature at stage 8 in degree cencius*/
Real T8(unit="K");/*temperature at stage 8 in degree kelvin unit*/
parameter Real epsilon=0.75;/*heat exchange effectiveness*/
parameter Real eta_LPC=0.88;/*isentropic efficiency of low pressure compressor*/
parameter Real eta_HPC=0.88;/*isentropic efficiency of high pressure compressor*/
parameter Real eta_HPT=0.85;/*isentropic efficiency of high pressure turbine*/
parameter Real eta_LPT=0.85;/*isentropic efficiency of low pressure turbine*/
parameter Real C_p(unit="kJ/kg.K")=1.005;/*specific heat of air*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

Real p2_by_p1;/*pressure ratio for process 2-1*/
Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T3(unit="K");/*temperature at stage 3*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real W_C(unit="kJ/kg");/*work of compression per kg of air supplied*/

Real p6_by_p7;/*pressure ratio for process 6-7*/
Real T7(unit="K");/*temperature at stage 7 for isentropic condition*/
Real T7_das(unit="K");/*actual temperature at stage 7*/
Real T9_das(unit="K");/*actual temperature at stage 9*/

Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_net(unit="kJ/kg");/*net work output*/
Real W_R;/*work ratio*/
Real T5(unit="K");/*temperature at stage 5*/ 
Real Q_s(unit="kJ/kg");/*heat supplied per kg of air*/
Real eta_th(unit="%");/*thermal efficiency*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T6=Modelica.SIunits.Conversions.from_degC(T6_degC);
T8=Modelica.SIunits.Conversions.from_degC(T8_degC);

p2_by_p1=sqrt(p4_by_p1);

T2/T1=p2_by_p1^((gama-1)/gama);
eta_LPC=(T2-T1)/(T2_das-T1);
T3=T1;
T4_das=T2_das;

W_C=2*C_p*(T2_das-T1);

p6_by_p7=sqrt(p6_by_p9);

T6/T7=p6_by_p7^((gama-1)/gama);
eta_HPT=(T6-T7_das)/(T6-T7);
T9_das=T7_das;

W_T=2*C_p*(T6-T7_das);
W_net=W_T-W_C;
W_R=W_net/W_T;

epsilon=(T5-T4_das)/(T9_das-T4_das);

Q_s=C_p*(T6-T5);

eta_th=(W_net/Q_s)*100;


/*The  answer may slightly vary due to  rounding off values and also the answer given in the book is wrong*/

end Ex5_15;
