class Ex5_3
/*pressure converssion from Pa to bar- 10^5 Pa= 1 bar*/
/*10 kPa=(10*10^3)/10^5 bar */

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="kJ/kg.K")=1.005;/*specific heat at constant pressure*/

parameter Real p1(unit="bar")=1.01325;/*pressure at inlet*/
parameter Real p4(unit="bar")=1.01325;/*pressure at stage4*/
parameter Real T1_degC(unit="degC")=15;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T3_degC(unit="degC")=750;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real p2_by_p1=6;/*pressure ratio for process 1-2*/
Real p2(unit="bar");/*pressure at stage 2*/
Real p3(unit="bar");/*pressure at stage3*/
parameter Real P(unit="kW")=1100;/*total net developed power*/
parameter Real eta_C=0.8;/*isentropic efficiency of compressor*/
parameter Real eta_T=0.8;/*isentropic efficiency of turbine*/
parameter Real eta_Comb=0.9;/*combustion efficiency*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/
Real W_net(unit="kJ/kg");/*work output per kg of air*/

Real m_adot(unit="kg/s");/*flow rate of air*/
Real Q_s(unit="kJ/kg");/*heat supplied per kg of air*/
Real Q_sa(unit="kJ/kg");/*actual heat supplied per kg of air*/
Real W_r;/*work ratio*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);
p2=p2_by_p1*p1;
p3=p2-(1/10);

T2/T1=(p2/p1)^((gama-1)/gama);
eta_C=(T2-T1)/(T2_das-T1);

T3/T4=(p3/p4)^((gama-1)/gama);
eta_T=(T3-T4_das)/(T3-T4);

W_T=C_p*(T3-T4_das);

W_C=C_p*(T2_das-T1);

W_net=W_T-W_C;
P=m_adot*W_net;


Q_s=C_p*(T3-T2_das);
Q_sa=Q_s/eta_Comb;
W_r=W_net/W_T;
/*The  answer may slightly vary due to  rounding off values*/
end Ex5_3;
