class Ex5_4
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p2_by_p1=6;/*pressure ratio for process 1-2*/
parameter Real p3_by_p4=6;/*pressure ratio for process 3-4*/
parameter Real T1_degC(unit="degC")=15;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T3_degC(unit="degC")=800;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real C_V(unit="kJ/kg")=44000;/*calorific value of fuel*/
parameter Real C_pg(unit="kJ/kg.K")=1.075;/*specific heat of exhaust gases*/
parameter Real C_pa(unit="kJ/kg.K")=1.005;/*specific heat of air*/
parameter Real eta_C=85/100;/*isentropic efficiency of compressor*/
parameter Real eta_T=87/100;/*isentropic efficiency of turbine*/
parameter Real eta_comb=98/100;/*combustion efficiency*/
parameter Real m_adot(unit="kg/s")=4;/*flow rate of air*/
parameter Real eta_mech=95/100;/*mechanical efficiency*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real m_adot_by_m_fdot;/*air fuel ratio*/
Real A_by_F;/*/*air fuel ratio*/

Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/
Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_net(unit="kJ/kg");/*work output per kg of air*/

Real I_P(unit="kW");/*indicated power of plant*/
Real Q_s(unit="kJ/kg");/*heat supplied per kg of air*/
Real eta_th(unit="%");/*thermal efficiency in percentage*/

Real m_fh(unit="kg/hr");/*fuel supply per hour*/
Real SFC(unit="kg/Kwr");/*specific fuel consumption*/

Real W_Ca(unit="kJ/kg");/*actual work needed to drive the compressor per kg of air*/
Real W_Ta(unit="kJ/kg");/*actual work delivered by turbine per kg of air*/

Real P_shaft(unit="kW");/*shaft power*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);

T2/T1=(p2_by_p1)^((gama-1)/gama);
eta_C=(T2-T1)/(T2_das-T1);

T3/T4=(p3_by_p4)^((gama-1)/gama);
eta_T=(T3-T4_das)/(T3-T4);

C_V*eta_comb=(1+m_adot_by_m_fdot)*C_pg*(T3-T2_das);
A_by_F=m_adot_by_m_fdot;

W_C=C_pa*(T2_das-T1);
W_T=(1+(1/m_adot_by_m_fdot))*C_pg*(T3-T4_das);
W_net=W_T-W_C;

I_P=m_adot*W_net;
Q_s=(1/m_adot_by_m_fdot)*eta_comb*C_V;

eta_th=(W_net/Q_s)*100;

m_fh=m_adot*3600*(1/m_adot_by_m_fdot);/*here m_adot has been multilied by 3600 to convert the unit from kg/s to kg/h*/
SFC= m_fh/I_P;

W_Ca=W_C/eta_mech;
W_Ta=W_T*eta_mech;


P_shaft=m_adot*(W_Ta-W_Ca);

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_4;
