class Ex5_5
parameter Real T1_degC(unit="degC")=15;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T3_degC(unit="degC")=610;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real p2_by_p1=6;/*pressure ratio for process 1-2*/
parameter Real p3_by_p4=6;/*pressure ratio for process 3-4*/
parameter Real eta_C=80/100;/*isentropic efficiency of compressor*/
parameter Real eta_T=85/100;/*isentropic efficiency of turbine*/
parameter Real eta_mech_Turbine=96/100;/*mechanical efficiency of turbine*/
parameter Real eta_generator=95/100;/*generator efficiency*/
parameter Real m_adot(unit="kg/s")=16;/*flow rate of air*/
parameter Real C_pa(unit="kJ/kg.K")=1.005;/*specific heat of air for process 1-2*/
parameter Real gama_C=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 1-2*/
parameter Real C_pg(unit="kJ/kg.K")=1.14;/*specific heat of gases for process 3-4*/
parameter Real gama_T=1.333;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 3-4*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/
Real W_net(unit="kJ/kg");/*work output per kg of air*/

Real P(unit="kW");/*total power delivered by turbine*/
Real P_E(unit="kW");/*electrical power delivered by generator*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);

T2/T1=p2_by_p1^((gama_C-1)/gama_C);
eta_C=(T2-T1)/(T2_das-T1);

T3/T4=p3_by_p4^((gama_T-1)/gama_T);
eta_T=(T3-T4_das)/(T3-T4);

W_C=C_pa*(T2_das-T1);
W_T=C_pg*(T3-T4_das);
W_net=W_T-W_C;

P=m_adot*W_net;
P_E=P*eta_mech_Turbine*eta_generator;

/*the value of P_E given in the book is wrong. The  answer may slightly vary due to  rounding off values*/
end Ex5_5;
