class Ex5_8
parameter Real gama=1.41;/*k=gama=ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="kJ/kg.K")=1.02;/*specific heat at constant pressure*/

parameter Real p5_by_p6=5.6;/*pressure ratio for process 5-6*/
parameter Real T1_degC(unit="degC")=30;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T5_degC(unit="degC")=700;/*temperature at stage 5 in degree Celcius unit*/
Real T5(unit="K");/*temperature at stage 5 in degree kelvin unit*/
parameter Real eta_C_LP=85/100;/*efficiency of low pressure compressor*/
parameter Real eta_C_HP=85/100;/*efficiency of high pressure compressor*/
parameter Real eta_T=90/100;/*efficiency of turbine*/
parameter Real m_adot(unit="kg/s")=1.2;/*mass flow rate*/

Real p4_by_p1;/*pressure ratio from process 1-4*/
Real p2_by_p1;/*pressure ratio for process 1-2*/
Real p4_by_p3;/*pressure ratio for process 3-4*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T3(unit="K");/*atemperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/
Real T6(unit="K");/*temperature at stage 6 for isentropic condition*/
Real T6_das(unit="K");/*actual temperature at stage 6*/

Real P_C(unit="kW");/*total power required to drive the compressor*/
Real P_T(unit="kW");/*power produced by turbine*/
Real P(unit="kW");/*net power available power*/

Real Q_s(unit="kW");/*heat supplied during process 4_das-5*/
Real eta_th(unit="%");/*efficiency of power plant*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T5=Modelica.SIunits.Conversions.from_degC(T5_degC);

p4_by_p1=p5_by_p6;
p2_by_p1=sqrt(p4_by_p1);
p4_by_p3=p2_by_p1;

T2/T1=(p2_by_p1)^((gama-1)/gama);
eta_C_LP=(T2-T1)/(T2_das-T1);

T3=T1;

T4/T3=(p4_by_p3)^((gama-1)/gama);
eta_C_HP=(T4-T1)/(T4_das-T3);

P_C=m_adot*C_p*((T2_das-T1)+(T4_das-T3));

T5/T6=(p5_by_p6)^((gama-1)/gama);
eta_T=(T5-T6_das)/(T5-T6);

P_T=m_adot*C_p*(T5-T6_das);
P=P_T-P_C;

Q_s=m_adot*C_p*(T5-T4_das);
eta_th=(P/Q_s)*100;
/*The  answer may slightly vary due to  rounding off values*/
end Ex5_8;
