class Ex5_9
parameter Real p2_by_p1=5;/*pressure ratio for process 1-2*/
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
Real p2(unit="bar");/*pressure at stage 2*/
parameter Real T1_degC(unit="degC")=30;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/

parameter Real eta_C=0.8;/*isentropic efficiency of compressor*/
parameter Real eta_HPT=0.85;/*isentropic efficiency of high pressure turbine*/
parameter Real eta_LPT=0.85;/*isentropic efficiency of low pressure turbine*/

parameter Real C_pa(unit="kJ/kg.K")=1.005;/*specific heat of air for process 1-2*/
parameter Real gama_C=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 1-2*/
parameter Real C_pg(unit="kJ/kg.K")=1.155;/*specific heat of gases for process 3-4*/
parameter Real gama_T=1.33;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 3-4*/

Real p3(unit="bar");/*pressure at stage 3*/
parameter Real p4(unit="bar")=2.236;/*pressure at stage 4*/
parameter Real p5(unit="bar")=2.236;/*pressure at stage 5*/
parameter Real P(unit="kW")=5*10^3;/*total delivered power*/

parameter Real T3_degC(unit="degC")=550;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real T5_degC(unit="degC")=550;/*temperature at stage 5 in degree Celcius unit*/
Real T5(unit="K");/*temperature at stage 5 in degree kelvin unit*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/

Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/

Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/
Real T6(unit="K");/*temperature at stage 6 for isentropic condition*/
Real T6_das(unit="K");/*actual temperature at stage 6*/

Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_net(unit="kJ/kg");/*work output per kg of air*/

Real m_adot(unit="kg/s");/*flow rate of air*/
Real Q_s(unit="kJ/kg");/*heat supply per kg of air*/

Real eta_overall(unit="%");/*overall efficiency*/
equation
p2=p2_by_p1*p1;
p3=p2;
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);
T5=Modelica.SIunits.Conversions.from_degC(T5_degC);

T2/T1=p2_by_p1^((gama_C-1)/gama_C);
eta_C=(T2-T1)/(T2_das-T1);

W_C=C_pa*(T2_das-T1);

T3/T4=(p3/p4)^((gama_T-1)/gama_T);
eta_HPT=(T3-T4_das)/(T3-T4);
T6=T4;
T6_das=T4_das;

W_T=C_pg*((T3-T4_das)+(T5-T6_das));
W_net=W_T-W_C;

P=m_adot*W_net;

Q_s=C_pg*((T3-T2_das)+(T5-T4_das));
eta_overall=(W_net/Q_s)*100;
/*The  answer may slightly vary due to  rounding off values*/
end Ex5_9;
