class Ex6_1
parameter Real pi = Modelica.Constants.pi;

parameter Real V_r1(unit="m/s")=240;/*relative velocity of flow w.r.t. blade at inlet*/
parameter Real beta_1das(unit="deg")=60;/*angle of flow at inlet w.r.t. axial direction in degree unit*/ 
Real beta_1das_R(unit="rad");/*angle of flow at inlet w.r.t. axial direction in radian unit*/
Real beta_1(unit="rad");/*blade angle at inlet w.r.t. flow relative velocity*/
parameter Real U(unit="m/s")=183;/*tangential velocity of blade*/
parameter Real W(unit="J/kg")=75*10^3;/*work developed in blades*/

Real BC(unit="m/s");
Real V_w1(unit="m/s");/*velocity of whirl at entry*/
Real V_f1(unit="m/s");/*velocity of flow of gas at entry*/
Real V1(unit="m/s");/*gas absolute velocity at nozzle exit*/
Real alpha_1(unit="rad");/*gas leaving angle at inlet*/
Real beta_2(unit="rad");/*angle made by rotor tip at outlet*/
Real V_w2(unit="m/s");/*velocity of whirl at outlet of rotor blade*/
Real V_r2(unit="m/s");/*relative velocity of flow w.r.t. blade at outlet*/
Real K;/*blade fricition coefficient*/
Real eta_b(unit="%");/*blade efficiency*/
equation
beta_1das_R=Modelica.SIunits.Conversions.from_deg(beta_1das);
beta_1=(pi/2)-beta_1das_R;
sin(beta_1das_R)=BC/V_r1;
V_w1=U+BC;
V_f1=V_r1*cos(beta_1das_R);
V1=sqrt(V_f1^2+V_w1^2);
tan(alpha_1)=V_f1/V_w1;
beta_2=beta_1;
W=U*(V_w1+V_w2);
cos(beta_2)=(U+V_w2)/V_r2;
K=V_r2/V_r1;
eta_b=(W/(V1^2/2))*100;
/*The  answer may slightly vary due to  rounding off values*/
end Ex6_1;
