class Ex6_4
parameter Real pi = Modelica.Constants.pi;
parameter Real alpha_1das(unit="deg")=60;/*gas leaving angle at inlet w.r.t. axial direction in degree unit*/
Real alpha_1das_R(unit="rad");/*gas leaving angle at inlet w.r.t. axial direction in radian unit*/
Real alpha_1(unit="rad");/*gas leaving angle at inlet*/

parameter Real alpha_2das(unit="deg")=28;/*gas leaving angle at outlet of rotor blade w.r.t. axial direction in degree unit*/
Real alpha_2das_R(unit="rad");/*gas leaving angle at outlet of rotor blade w.r.t. axial direction in radian unit*/
Real alpha_2(unit="rad");/*gas leaving angle at outlet of rotor blade w.r.t. rotor direction*/

Real beta_1deg(unit="deg");/*blade angle at inlet w.r.t. flow relative velocity in degree unit*/
Real beta_2deg(unit="deg");/*blade angle at outlet w.r.t. flow relative velocity in degree unit*/
Real beta_2(unit="rad");/*blade angle at outlet w.r.t. flow relative velocity in radian unit*/

parameter Real V2(unit="m/s")=300;/*absolute velocity at outlet of rotor blade*/
parameter Real U(unit="m/s")=200;/*tangential velocity of blade*/

Real V_f1(unit="m/s");/*velocity of flow of gas at entry*/
Real V_f2(unit="m/s");/*velocity of flow of gas at outlet*/

Real V_w1(unit="m/s");/*velocity of whirl at inlet of rotor blade*/
Real V_w2(unit="m/s");/*velocity of whirl at outlet of rotor blade*/

Real W_D(unit="kW");/*produced power*/
Real V1(unit="m/s");/*gas absolute velocity at nozzle exit*/
Real eta_b(unit="%");/*blade efficiency*/

equation
alpha_1das_R=Modelica.SIunits.Conversions.from_deg(alpha_1das);
alpha_1=(pi/2)-alpha_1das_R;
alpha_2das_R=Modelica.SIunits.Conversions.from_deg(alpha_2das);
alpha_2=(pi/2)-alpha_2das_R;

V_f2=V2*cos(alpha_2das_R);
V_f1=V_f2;
V_w2=V2*sin(alpha_2das_R);
V_w1=V_f1*tan(alpha_1das_R);

tan(beta_2)=V_f2/(U+V_w2);
beta_2deg=Modelica.SIunits.Conversions.to_deg(beta_2);
beta_1deg=beta_2deg;

W_D=(U*(V_w1+V_w2))/1000;

V1=sqrt(V_w1^2+V_f1^2);
eta_b=((W_D*1000)/(V1^2/2))*100;

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_4;
