class Ex7_1
parameter Real pi = Modelica.Constants.pi;

parameter Real U(unit="m/s")=210;/*blade speed*/
parameter Real D(unit="m")=80/100;/*diameter of the wheel*/

parameter Real sigma_ras=0.505;/*optimal value of velocity ratio at rateau stage*/
Real dh_ras(unit="kJ/kg");/*enthalpy drop at rateau stage*/
 
parameter Real sigma_Cs=0.29;/*optimal value of velocity ratio at Curtis stage*/
Real dh_Cs(unit="kJ/kg");/*enthalpy drop at rateau stage*/

parameter Real sigma_res=0.85;/*optimal value of velocity ratio at reaction stage*/
Real dh_res(unit="kJ/kg");/*enthalpy drop at reaction stage*/

Real N(unit="r.p.m");/*r.p.m. of the wheel*/
equation
dh_ras=((U/sigma_ras)^2*(1/2))/1000;
dh_Cs=((U/sigma_Cs)^2*(1/2))/1000;
dh_res=((U/sigma_res)^2*(1/2))/1000;

U=(pi*D*N)/60;
end Ex7_1;
