class Ex7_3
parameter Real r_tip(unit="cm")=120;/*tip diameter*/
parameter Real r_hub(unit="cm")=60;/*hub diameter*/
Real r_mean(unit="cm");/*mean diameter*/

Real R_mean;/*degree of reaction at mean diameter*/
Real R_tip;/*degree of reaction at tip blade*/
Real R_hub;/*degree of reaction at hub*/
Real R_35;/*degree of reaction at 35cm above hub*/
equation
r_mean=(r_tip+r_hub)/2;
R_mean=1-(r_hub/r_mean)^2;
R_tip=1-(r_hub/r_tip)^2;
R_hub=1-(r_hub/r_hub)^2;
R_35=1-(r_hub/(r_hub+35))^2;

end Ex7_3;
