class Ex9_10
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/

parameter Real V_a_kmph(unit="kmph")=805;/*speed of the aircraft in kmph unit*/
Real V_a(unit="m/s");/*speed of the aircraft in m/s unit*/

parameter Real p1(unit="bar")=0.458;/*pressure at intake-1*/
parameter Real p6(unit="bar")=0.458;/*pressure at outlet-6*/
parameter Real T1_degC(unit="degC")=-25;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real p3_by_p2_das=4;/*pressure ratio for compression process 2_das-3*/
Real p3(unit="bar");/*pressure at stage-3*/
Real p4(unit="bar");/*pressure at stage-4*/
parameter Real T4(unit="K")=1100;/*temperature at stage 4*/

parameter Real eta_D=95/100;/*intake duct efficiency*/
parameter Real eta_C=85/100;/*efficiency of compressor*/
parameter Real eta_T=90/100;/*efficiency of turbine*/
parameter Real eta_mech_transmission=98/100;/*mechanical efficiency*/

parameter Real A(unit="m^2")=0.1;/*nozzle outlet area*/
parameter Real C_V(unit="J/kg")=44*10^3*10^3;/*calorific value of fuel*/

parameter Real C_pa(unit="J/kg.K")=1.005*10^3;/*specific heat of air for process 2-3*/
parameter Real gama_a=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 2-3*/
parameter Real C_pg(unit="J/kg.K")=1.147*10^3;/*specific heat of gases for process 3-4*/
parameter Real gama_g=1.33;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 3-4*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real p2(unit="bar");/*isentropic pressure at stage 2*/
Real p2_das(unit="bar");/*actual pressure at stage 2*/

Real T3(unit="K");/*temperature at stage 3 for isentropic condition*/
Real T3_das(unit="K");/*actual temperature at stage 3*/
Real T5_das(unit="K");/*actual temperature at stage 5*/
Real T5(unit="K");/*temperature at stage 5 for isentropic condition*/
Real p5(unit="bar");/*isentropic pressure at stage-5*/
Real p5_das(unit="bar");/*actual pressure at stage-5*/

Real p5_das_by_p6_das;/*actual pressure ratio for process 5_das-6_das*/
//Real p5_by_p6;/*isentropic pressure ratio for process 5-6*/
Real p5_das_by_p_star;/*critical pressure ratio*/

Real T_star(unit="K");/*critical temperature*/
Real p_star(unit="bar");/*critical pressure*/
Real rho_star(unit="kg/m^3");/*critical density*/

Real V_j(unit="m/s");/*velocity at exit of jet*/
Real m_gdot(unit="kg/s");/*mass flow rate of gases*/
Real T_M(unit="N");/*momentum thrust*/
Real T_P(unit="N");/*pressure thrust*/
Real T(unit="N");/*total thrust*/
Real m_fdot(unit="kg/s");/*fuel flow rate*/
Real TSFC(unit="kg/N-h");/*specefic fuel consumption based on thrust*/
Real m_adot(unit="kg/s");/*air flow rate*/
Real A_F;/*air fuel ratio*/

equation
V_a=(V_a_kmph*1000)/3600;

T1=Modelica.SIunits.Conversions.from_degC(T1_degC);

C_pa*T1+V_a^2/2=C_pa*T2;
T2_das=T2;

T2/T1=(p2/p1)^((gama_a-1)/gama_a);
eta_D=(p2_das-p1)/(p2-p1);

T3/T2_das=p3_by_p2_das^((gama_a-1)/gama_a);
eta_C=(T3-T2_das)/(T3_das-T2_das);

C_pg*(T4-T5_das)=(C_pa*(T3_das-T2_das))/eta_mech_transmission;

eta_T=(T4-T5_das)/(T4-T5);
p3=p3_by_p2_das*p2_das;
p4=p3-0.21;
p4/p5=(T4/T5)^(gama_g/(gama_g-1));
p5_das=p5;

p5_das_by_p6_das=p5/p6;
1/p5_das_by_p_star=(2/(gama_g+1))^(gama_g/(gama_g-1));
T_star/T5_das=2/(gama_g+1);
p_star=(1/p5_das_by_p_star)*p5_das;
rho_star=(p_star*10^5)/(R*T_star);
V_j=sqrt(gama_g*R*T_star);
m_gdot=rho_star*A*V_j;

T_M=m_gdot*(V_j-V_a);
T_P=A*(p_star*10^5-p6*10^5);
T=T_M+T_P;
m_fdot*C_V=C_pg*(T4-T3_das)*m_gdot;
TSFC=(m_fdot*3600)/T;
m_gdot=m_adot+m_fdot;
A_F=m_adot/m_fdot;

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_10;
