class Ex9_11
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M=0.7;/*Mach number of the plane*/
parameter Real p(unit="bar")=0.55;/*atmospheric pressure*/
parameter Real T(unit="K")=255;/*atmospheric temperature */
parameter Real P_T(unit="W")=1300*10^3;/*developed thrust power*/
parameter Real eta_prop=50/100;/*propulsive efficiency*/

Real C(unit="m/s");/*speed of sound*/
Real V_a(unit="m/s");/*velocity of plane*/
Real D(unit="N");/*thrust or drag of plane*/
Real V_j(unit="m/s");/*exit velocity of jet*/
equation
C=sqrt(gama*R*T);
V_a=M*C;
P_T=D*V_a;

eta_prop=(2*V_a)/(V_j+V_a);

end Ex9_11;
