class Ex9_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real p1(unit="bar")=1.03;/*intake pressure*/
Real p5(unit="bar");/*nozzle exit pressure*/
parameter Real p3(unit="bar")=4.5;/*pressure at inlet of turbine*/
parameter Real p4(unit="bar")=1.75;/*isentropic pressure at outlet of turbine*/
parameter Real p4_das(unit="bar")=1.75;/*actual pressure at outlet of turbine*/
parameter Real T3_degC(unit="degC")=800;/*temperature at inlet of turbine in degree celcius*/
Real T3(unit="K");/*temperature at inlet of turbine in kelvin unit*/
parameter Real eta_T=0.75;/*efficiency of turbine*/
parameter Real C_v=1;/*velocity coefficient-assuming*/

Real T4(unit="K");/*isentropic temperature after expansion in the turbine*/
Real T4_das(unit="K");/*actual temperature after expansion in the turbine*/
Real T5(unit="K");/*isentropic temperature after expansion in the nozzle*/
Real V_j(unit="m/s");/*velocity of jet*/
equation
p5=p1;
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);

T3/T4=(p3/p4)^((gama-1)/gama);
eta_T=(T3-T4_das)/(T3-T4);

T4_das/T5=(p4_das/p5)^((gama-1)/gama);

V_j=C_v*sqrt(2*C_p*(T4_das-T5));
/*the answer given in the book for Vj is wrong*/
end Ex9_2;
