class Ex9_3
parameter Real T(unit="N")=9*10^3;/*thrust*/
parameter Real TSFC(unit="kg/(N*s)")=0.18/3600;/*thrust specefic fuel consumption*/
parameter Real V_a(unit="m/s")=500;/*speed of the aircraft*/
parameter Real m_adot(unit="kg/s")=27;/*air flow rate*/

Real V_j(unit="m/s");/*exit velocity of jet*/
Real m_fdot(unit="kg/s");/*fuel flow rate*/
Real A_F;/*air fuel ratio*/
Real P_T(unit="W");/*thrust power*/
Real eta_prop(unit="%");/*propulsive efficiency*/
parameter Real  C_V(unit="J/kg")=44000*10^3;/*calorific value of fuel-assuming*/
parameter Real eta_comb=100/100;/*combustion efficiency*/
Real eta_th(unit="%");/*thermal efficiency*/
Real eta_overall(unit="%");/*overall efficiency*/
equation
T=m_adot*(V_j-V_a);
m_fdot=TSFC*T;
A_F=m_adot/m_fdot;

P_T=T*V_a;

eta_prop=((2*V_a)/(V_j+V_a))*100;

eta_th=(((1/2)*(m_adot/m_fdot)*(V_j^2-V_a^2))/(C_V*eta_comb))*100;

eta_overall=(eta_prop/100)*(eta_th/100)*100;
/*the answer given in the book for eta_th and eta_overall are wrong*/
end Ex9_3;
