class Ex9_4
parameter Real V_a_kmph(unit="kmph")=600;/*speed of the aircraft in kmph unit*/
Real V_a(unit="m/s");/*speed of the aircraft in m/s unit*/
parameter Real  C_V(unit="J/kg")=44000*1000;/*calorific value of fuel*/
parameter Real m_adot_by_m_fdot=80;/*air to fuel ratio*/
parameter Real m_adot(unit="kg/s")=20;/*air flow rate*/

Real Q_s(unit="J/kg");/*energy supplied due to combustion of fuel per kg of air*/
Real V_j(unit="m/s");/*exit velocity of jet*/
Real eta_prop(unit="%");/*propulsive efficiency*/
Real eta_th(unit="%");/*thermal efficiency*/
Real eta_overall(unit="%");/*overall efficiency*/
equation
V_a=(V_a_kmph*1000)/3600;
Q_s=(1/m_adot_by_m_fdot)*C_V;
(1/2)*V_j^2=0.5*Q_s;

eta_prop=((2*V_a)/(V_a+V_j))*100;
eta_th=(((1/2)*(V_j^2-V_a^2))/((1/m_adot_by_m_fdot)*C_V))*100;

eta_overall=(eta_prop/100)*(eta_th/100)*100;

end Ex9_4;
