class Ex9_6
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/

parameter Real N_j=2;/*number of jet*/
parameter Real V_a_kmph(unit="kmph")=900;/*speed of the aircraft in kmph unit*/
Real V_a(unit="m/s");/*speed of the aircraft in m/s unit*/
parameter Real rho_a(unit="kg/m^3")=0.17;/*ambient density*/
parameter Real T(unit="N")=7*10^3;/*total drag on plane*/
parameter Real eta_prop=60/100;/*propulsive efficiency*/
parameter Real  C_V(unit="J/kg")=42000*1000;/*calorific value of fuel*/
parameter Real eta_o=17/100;/*overall efficiency*/

Real V_j(unit="m/s");/*exit velocity of jet*/
Real m_adot(unit="kg/s");/*air flow rate*/
Real m_adot_by_m_fdot;/*air to fuel ratio*/
Real m_fdot_by_m_adot;/*fuel to air ratio*/
Real P_t(unit="W");/*thrust power*/
Real P_p(unit="W");/*propulsive power*/
Real TSFC(unit="kg/(N-hr)");/*thrust specefic fuel consumption*/
Real d(unit="m");/*diameter of jet*/

equation
V_a=(V_a_kmph*1000)/3600;

eta_prop=((2*V_a)/(V_a+V_j));

T=m_adot*(V_j-V_a);

eta_o=(m_adot_by_m_fdot*(V_j-V_a)*V_a)/C_V;
m_fdot_by_m_adot=1/m_adot_by_m_fdot;

P_t=T*V_a;
P_p=(1/2)*m_adot*(V_j^2-V_a^2);
TSFC=(m_fdot_by_m_adot*m_adot*3600)/T;

m_adot=rho_a*(pi/4)*d^2*V_j*N_j;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_6;
