class Ex9_9
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real C_pa(unit="J/kg.K")=1.005*10^3;/*specific heat of air for process 2-3*/
parameter Real gama_a=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 2-3*/
parameter Real C_pg(unit="J/kg.K")=1.15*10^3;/*specific heat of gases for process 3-4*/
parameter Real gama_g=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 3-4*/

parameter Real V_a_kmph(unit="kmph")=720;/*speed of the aircraft in kmph unit*/
Real V_a(unit="m/s");/*speed of the aircraft in m/s unit*/

parameter Real T1_degC(unit="degC")=-18;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real p3_by_p2_das=9;/*pressure ratio for compression process 2_das-3*/
parameter Real T4_degC(unit="degC")=800;/*temperature at stage 4 in degree Celcius unit*/
Real T4(unit="K");/*temperature at stage 4 in degree kelvin unit*/

parameter Real eta_D=90/100;/*intake duct efficiency*/
parameter Real eta_C=86/100;/*efficiency of compressor*/
parameter Real eta_T=90/100;/*efficiency of turbine*/
parameter Real eta_mech=92/100;/*mechanical efficiency*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real p2_by_p1;/*isentropic pressure ratio for process 1-2*/
Real p2_das_by_p1;/*actual pressure ratio for process 1-2*/
Real T3(unit="K");/*temperature at stage 3 for isentropic condition*/
Real T3_das(unit="K");/*actual temperature at stage 3*/
Real p4_by_p5;/*pressure ratio for process 4-5*/
Real T5(unit="K");/*temperature at stage 5 for isentropic condition*/
Real T5_das(unit="K");/*actual temperature at stage 5*/

Real W_C(unit="J/kg");/*work required to drive the compressor*/
Real W_T(unit="J/kg");/*work developed by the turbine*/
Real W_net(unit="J/kg");/*net work*/

Real Q_s(unit="J/kg");/*energy supplied in combustion chamber during process 3_das-4*/
Real eta_th;/*thermal efficiency*/

equation
V_a=(V_a_kmph*1000)/3600;

T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T4=Modelica.SIunits.Conversions.from_degC(T4_degC);

C_pa*T1+V_a^2/2=C_pa*T2;
T2_das=T2;

T2/T1=p2_by_p1^((gama_a-1)/gama_a);
eta_D=(p2_das_by_p1-1)/(p2_by_p1-1);

T3/T2_das=p3_by_p2_das^((gama_a-1)/gama_a);
eta_C=(T3-T2_das)/(T3_das-T2_das);

p4_by_p5=p3_by_p2_das*p2_das_by_p1;

T4/T5=p4_by_p5^((gama_g-1)/gama_g);
eta_T=(T4-T5_das)/(T4-T5);

W_C=C_pa*(T3_das-T2_das);
W_T=C_pg*(T4-T5_das);
W_net=W_T*eta_mech-W_C/eta_mech;

Q_s=C_pg*(T4-T3_das);
eta_th=W_net/Q_s;

/*the answer given in the book is wrong*/

end Ex9_9;
