package Ex27_11
  model Ex27_11_a
    parameter Real w(unit = "g") = 20 "Mass of glucose";
    parameter Real m(unit = "g/mole") = 180 "Molecular Mass of glucose ";
    parameter Real W(unit = "kg") = 0.05 "Mass of Solvent";
    Real n(unit = "Moles") "No. of Moles";
    Real M(unit = "Moles") "Molality";
    Real f(unit = "Deg.C") "Freezing Point";
  equation
    n = w / m;
    M = n / W;
    f = M * 1.86;
//1m solution reduces freezing point of water by 1.86 Deg.C
  end Ex27_11_a;


  model Ex27_11_b
  parameter Real M(unit = "Moles") = 2.2 "Molality";  //from 27_11_a
  Real b(unit = "Deg.C") "Boiling Point";
  equation
  b = M * 0.52;
  //1m solution raises boiling  point of water by 0.52 Deg.C
  end Ex27_11_b;









end Ex27_11;
