package Ex4_15
  model Ex4_15_a
    parameter Real G(unit = "Nmsquare/kg square") = 6.67 * 10 ^ (-11) "universal gravitational constant ";
    parameter Real mm(unit = "kg") = 7.36 * 10 ^ 22 "mass of moon ";
    parameter Real r(unit = "m") = 1.74 * 10 ^ 6 "radius of moon ";
    parameter Real m(unit = "kg") = 75 "mass of man ";
    Real g(unit = "m/sec^2") "Acceleration of gravity";
  equation
    g = G * mm / (r * r);
  end Ex4_15_a;


  model Ex4_15_b
    parameter Real G(unit = "Nmsquare/kg square") = 6.67 * 10 ^ (-11) "universal gravitational constant ";
    parameter Real mm(unit = "kg") = 7.36 * 10 ^ 22 "mass of moon ";
    parameter Real r(unit = "m") = 1.74 * 10 ^ 6 "radius of moon ";
    parameter Real m(unit = "kg") = 75 "mass of man ";
    Real g(unit = "m/sec^2") "Acceleration of gravity";
    Real w(unit = "N") "weight on moon ";
  equation
    g = G * mm / (r * r);
    w = m * g;
  end Ex4_15_b;


end Ex4_15;
