class Ex2_12
parameter Real t(unit="s")=60;/*specefied time*/
parameter Real v_kmph(unit="km/h")=250;/*take off velocity of the aircraft in km/h unit*/
Real v_0(unit="m/s");/*take off velocity of the aircraft in m/s unit*/
parameter Real a(unit="m/s^2")=0.8;/*acceleration along the flight path*/
Real v(unit="m/s");/*velocity of the aircraft after 60 second*/
Real s(unit="m");/*distance traveled after take off*/

parameter Real alpha_deg(unit="deg")=15;/*angle between trajectory and y_das in degree unit*/
Real alpha(unit="rad");/*angle between trajectory and y_das in radian unit*/

parameter Real x(unit="m")=3000;/*x-coordinate of the aircraft w.r.t xyz frame*/
Real y(unit="m");/*y-coordinate of the aircraft w.r.t xyz frame*/

Real theta(unit="rad");/*azimuth angle of the aircraft w.r.t xyz frame*/
Real theta_dot(unit="rad/s");/*change of rate of azimuth angle of the aircraft w.r.t xyz frame*/
Real r(unit="m");/*radial distance of the aircraft in xy plane*/
Real r_dot(unit="m/s");/*rate of change of r*/
Real v_xy(unit="m/s");/*projection of the velocity in xy plane*/
Real z_dot(unit="m/s");/*first derivative of z-coordinate*/

Real z(unit="m");/*vertical position of the aircraft w.r.t. xyz-coordinate*/
Real R(unit="m");/*actual radial distance of the aircraft w.r.t O*/
Real R_dot(unit="m/s");/*1st derivative of R*/
Real phi(unit="rad");/*elevation angle of the aircraft w.r.t xyz frame*/
Real phi_dot(unit="rad/s");/*change of rate of elevation angle of the aircraft w.r.t xyz frame*/

equation
v_0=v_kmph*(1000/3600);
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
v=v_0+a*t;
s=v_0*t+(1/2)*a*t^2;

y=s*cos(alpha);
theta=atan(y/x);

r=sqrt(x^2+y^2);
v_xy=v*cos(alpha);
r_dot=v_xy*sin(theta);
r*theta_dot=v_xy*cos(theta);
z_dot=v*sin(alpha);

z=y*tan(alpha);
phi=atan(z/r);
R=sqrt(r^2+z^2);
R_dot=r_dot*cos(phi)+z_dot*sin(phi);
R*phi_dot=z_dot*cos(phi)-r_dot*sin(phi);

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_12;

