class Ex2_5

/*the stop time should be taken 5 seconds to the simulation result*/

Real v_x(unit="m/s");/*component of velocity in x direction*/
Real v_y(unit="m/s");/*component of velocity in y direction*/
Real v_y_ana(unit="m/s");/*component of velocity in y direction from analyical solution*/

Real y(unit="m");/*displacement in y direction*/ 
Real x(unit="m");/*displacement in x direction*/
Real x_ana(unit="m");/*displacement in x direction from analyical solution*/

Real a_x(unit="m/s^2");/*component of acceleration in x direction*/
Real a_y(unit="m/s^2");/*component of acceleration in y direction*/

Real a_x_ana(unit="m/s^2");/*component of acceleration in x direction from analyical solution*/
Real a_y_ana(unit="m/s^2");/*component of acceleration in y direction from analyical solution*/

Real v_x_y0(unit="m/s");/*component of velocity in x direction when y=0*/
Real v_y_y0(unit="m/s");/*component of velocity in y direction when y=0*/
Real v_y0_mag(unit="m/s");/*magnitude of the velocity when y=0*/
Real v_y0[2](each unit="m/s");/*velocity when y=0*/

Real a_x_y0(unit="m/s^2");/*component of acceleration in x direction when y=0*/
Real a_y_y0(unit="m/s^2");/*component of acceleration in y direction when y=0*/
Real a_y0_mag(unit="m/s^2");/*magnitude of the acceleration when y=0*/
Real a_y0[2](each unit="m/s^2");/*magnitude of the acceleration when y=0*/

equation
v_x=50-16*time;
y=100-4*time^2;

der(x)=v_x;
x_ana=50*time-8*time^2;

a_x=der(v_x);
a_x_ana=-16;

v_y=der(y);
v_y_ana=-8*time;

a_y=der(v_y);
a_y_ana=-8;

when y>=-0.01 and y<=0.08 then
v_x_y0=v_x;
v_y_y0=v_y;
v_y0_mag=sqrt(v_x_y0^2+v_y_y0^2);
v_y0={v_x_y0,v_y_y0};

a_x_y0=a_x;
a_y_y0=a_y;
a_y0_mag=sqrt(a_x_y0^2+a_y_y0^2);
a_y0={a_x_y0,a_y_y0};
end when;
/*the result are not exactly matching as instead of y=0 s it has taken a value which is near to zero*/
end Ex2_5;
