class Ex2_9

/*the stop time should be taken 4 seconds to the simulation result*/

Real r(unit="m");/*distance of power screw from point O*/
Real r_dot(unit="m/s");/*1st derivative of r*/
Real r_ddot(unit="m/s^2");/*2nd derivative of r*/

Real r_3(unit="m");/*distance of power screw from point O after 3 second*/
Real r_3dot(unit="m/s");/*1st derivative of r after 3 second*/
Real r_3ddot(unit="m/s^2");/*2nd derivative of r after 3 second*/

Real theta(unit="rad");/*angular position of the radially slotted arm*/
Real theta_dot(unit="rad/s");/*1st derivative of theta*/
Real theta_ddot(unit="rad/s^2");/*2nd derivative of theta*/

Real theta_3(unit="rad");/*angular position of power screw from point O after 3 second in radian unit*/
Real theta_3dot(unit="rad/s");/*1st derivative of theta after 3 second*/
Real theta_3ddot(unit="rad/s^2");/*2nd derivative of theta after 3 second*/

Real v_r(unit="m/s");/*radial velocity of the slider*/
Real v_theta(unit="m/s");/*angular velocity of the slider*/
Real v(unit="m/s");/*absolute velocity of the slider*/

Real a_r(unit="m/s^2");/*radial acceleration of the slider*/
Real a_theta(unit="m/s^2");/*angular acceleration of the slider*/
Real a(unit="m/s^2");/*absolute acceleration of the slider*/

Real x(unit="m");/*x-coordinate of the slider in cartetian coordinate*/
Real y(unit="m");/*y-coordinate of the slider in cartetian coordinate*/

equation
r=0.2+0.04*time^2;
r_dot=der(r);
r_ddot=der(r_dot);

theta=0.2*time+0.02*time^3;
theta_dot=der(theta);
theta_ddot=der(theta_dot);

when time==3 then
r_3=r;
r_3dot=r_dot;
r_3ddot=r_ddot;

theta_3=theta;
theta_3dot=theta_dot;
theta_3ddot=theta_ddot;

v_r=r_3dot;
v_theta=r_3*theta_3dot;
v=sqrt(v_r^2+v_theta^2);

a_r=r_3ddot-r_3*theta_3dot^2;
a_theta=r_3*theta_3ddot+2*r_3dot*theta_3dot;
a=sqrt(a_r^2+a_theta^2);
end when;

x=r*cos(theta);
y=r*sin(theta);
end Ex2_9;
