class EX3_13
parameter Real m(unit="kg")=50;/*mass of the block*/

parameter Real x1(unit="m")=0.233;/*initial position(A) of block*/
parameter Real AB(unit="m")=1.2;/*distance between point A and B*/
Real x2(unit="m");/*final position(B) of block*/
parameter Real k(unit="N/m")=80;/*spring constant*/

parameter Real T(unit="N")=300;/*constant force in the cable*/
parameter Real BC(unit="m")=0.9;/*distance between B and C*/
Real x3(unit="m");/*net horizontal movement of the cable over pully*/
Real U_12(unit="J");/*total work done on the block by the spring*/

Real v(unit="m/s");/*velocity at point B*/
equation
x2=x1+AB;
U_12=(1/2)*k*(x1^2-x2^2);
x3=sqrt(AB^2+BC^2)-BC;
0+U_12+T*x3=(1/2)*m*v^2;
end EX3_13;