class Ex3_17
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=10;/*mass of the slider*/
parameter Real k(unit="N/m")=60;/*stifness of the spring*/
parameter Real T(unit="N")=250;/*applied force*/
parameter Real AC(unit="m")=1.2;/*length of AC*/
parameter Real BC(unit="m")=0.9;/*length of BC*/
Real AB(unit="m");/*length of AB*/
Real x1(unit="m");/*moving distance of force*/
Real h(unit="m");/*height of the slider from base*/
parameter Real alpha_deg(unit="deg")=30;/*angle of the slider in deg unit*/
Real alpha(unit="rad");/*angle of the slider in radian unit*/

parameter Real x_A(unit="m")=0.6;/*stretched length of the spring in position A*/
Real x_C(unit="m");/*stretched length of the spring in position C*/

Real T_A(unit="J");/*kinetic energy at point A*/
Real U_AC(unit="J");/*work done by tensile force*/

Real V_Ag(unit="J");/*gravitational potential energy at position A*/ 
Real V_Cg(unit="J");/*gravitational potential energy at position C*/
Real V_Ae(unit="J");/*elastic potential energy at position A*/ 
Real V_Ce(unit="J");/*elastic potential energy at position C*/

Real v_C(unit="m/s");/*velocity of the slider at position C*/
equation
AB=sqrt(AC^2+BC^2);
x1=AB-BC;
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
h=AC*sin(alpha);
T_A=0;
U_AC=T*x1;
V_Ag=0;
V_Cg=m*g*h;
V_Ae=(1/2)*k*x_A^2;
x_C=x1+AC;
V_Ce=(1/2)*k*x_C^2;

T_A+V_Ag+V_Ae+U_AC=(1/2)*m*v_C^2+V_Cg+V_Ce;

end Ex3_17;
