class Ex3_19
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=60/1000;/*mass of the the ball*/
parameter Real dt(unit="s")=0.02;/*duration of impact time*/

parameter Real alpha_deg(unit="deg")=15;/*angle between v1 and v2 in deg unit*/
Real alpha(unit="rad");/*angle between v1 and v2 in radian unit*/
parameter Real v_x1(unit="m/s")=15;/*horizontal velocity of the ball just before impact with racket*/
parameter Real v_y1(unit="m/s")=0;/*vertical velocity of the ball just before impact with racket*/

parameter Real v_2(unit="m/s")=21;/*velocity of the ball just after impact with racket*/
Real v_x2(unit="m/s");/*horizontal velocity of the ball just after impact with racket*/
Real v_y2(unit="m/s");/*vertical velocity of the ball just after impact with racket*/

Real R(unit="N");/*magnitude of the average force exerted by the racket on the ball*/
Real R_x(unit="N");/*horizonal component of the average force exerted by the racket on the ball*/
Real R_y(unit="N");/*vertical component of the average force exerted by the racket on the ball*/

Real beta(unit="rad");/*angle of force R with the horizontal in radian unit*/
Real beta_deg(unit="deg");/*angle of force R with the horizontal in degree unit*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
v_x2=v_2*cos(alpha);
v_y2=v_2*sin(alpha);

-m*v_x1+R_x*dt=m*v_x2;
m*v_y1+R_y*dt-m*g=m*v_y2;

R=sqrt(R_x^2+R_y^2);
beta=atan(R_y/R_x);
beta_deg=Modelica.SIunits.Conversions.to_deg(beta);

/*The answer given in the book is wrong*/

end Ex3_19;
