class Ex3_2
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real x(unit="m")=12;/*base length of the triangle*/
parameter Real y(unit="m")=5;/*vertical length of the triangle*/
Real z(unit="m");/*hypotenuse of the  triangle*/

parameter Real m(unit="kg")=200;/*mass of the inspection car*/
parameter Real T(unit="N")=2.4*10^3;/*tension in the control cable*/

Real a(unit="m/s^2");/*acceleration of the car*/
Real P(unit="N");/*total force exerted by the supporting cable*/
equation
z=sqrt(x^2+y^2);
P-T*(y/z)-m*g*(x/z)=0;
T*(x/z)-m*g*(y/z)=m*a;
end Ex3_2;
