class Ex3_22
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=150;/*mass of the the ball*/


parameter Real alpha_deg(unit="deg")=30;/*angle of the incline track*/
Real alpha(unit="rad");/*angle between v1 and v2 in radian unit*/
parameter Real v(unit="m/s")=4;/*velocity of the skip*/
parameter Real P(unit="N")=600;/*force at 4s*/
parameter Real t1(unit="s")=4;/*time for case a*/
parameter Real t2(unit="s")=8;/*time for case b*/
Real dt(unit="s");/*extra time required to reverse the direction*/
Real t_das(unit="s");/*total time required to reverse the direction*/
Real v_x2(unit="m/s");/*velocity of the skip after 8s*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
m*(-v)+(1/2)*t1*2*P+2*P*dt-m*g*sin(alpha)*(t1+dt)=m*0;
t_das=(t1+dt);
m*(-v)+(1/2)*t1*2*P+2*P*t1-m*g*sin(alpha)*t2=m*v_x2; 
end Ex3_22;
