class Ex3_29
parameter Real v(unit="m/s")=16;/*initial magnitude of the velocity of the ball*/
parameter Real alpha_deg(unit="deg")=30;/*direction of the ball w.r.t. plate in degree unit before impact*/
Real alpha(unit="rad");/*direction of the ball w.r.t. plate in radian unit before impact*/

Real v1_n(unit="m/s");/*n-component of the velocity of the ball before impact*/
Real v1_t(unit="m/s");/*t-component of the velocity of the ball before impact*/
Real v1_n_das(unit="m/s");/*n-component of the velocity of the ball after impact*/
Real v1_t_das(unit="m/s");/*t-component of the velocity of the ball after impact*/

parameter Real v2_n(unit="m/s")=0;/*n-component of the velocity of the plate before impact*/
parameter Real v2_n_das(unit="m/s")=0;/*n-component of the velocity of the plate after impact*/
parameter Real e=0.5;/*coefficient of restitution*/

Real v_das(unit="m/s");/*rebound velocity of the ball*/

Real theta_das(unit="rad");/*direction of the ball w.r.t. plate in radian unit after impact*/
Real theta_deg_das(unit="deg");/*direction of the ball w.r.t. plate in degree unit after impact*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
v1_n=v*sin(alpha);
e=(v2_n_das-v1_n_das)/(-v1_n-v2_n);
v1_t=v*cos(alpha);
v1_t_das=v1_t;

v_das=sqrt(v1_n_das^2+v1_t_das^2);
tan(theta_das)=v1_n_das/v1_t_das;
theta_deg_das=Modelica.SIunits.Conversions.to_deg(theta_das);

end Ex3_29;
