class Ex3_31
parameter Real pi = Modelica.Constants.pi;

parameter Real g(unit="m/s^2")=9.825;/*acceleration due to gravity*/
parameter Real R(unit="m")=6371*10^3;/*radius of the earth*/
parameter Real h_P(unit="m")=2000*10^3;/*perigee altitude*/ 
parameter Real h_A(unit="m")=4000*10^3;/*apogee altitude*/
parameter Real h_C(unit="m")=2500*10^3;/*altitude of point C*/

Real r_min(unit="m");/*distance of perigee from center O*/ 
Real r_max(unit="m");/*distance of apoigee from center O*/
Real a(unit="m");/*semi major axis of the orbit*/ 
Real r(unit="m");/*distance of C from center O*/ 
Real v_P(unit="m/s");/*perigee velocity*/
Real v_A(unit="m/s");/*apogee velocity*/
Real v_C(unit="m/s");/*velocity at point C*/
Real tau(unit="s");/*period of the orbit*/
equation
r_max=R+h_A;
r_min=R+h_P;
a=(r_max+r_min)/2;
r=R+h_C;
v_P=R*sqrt(g/a)*sqrt(r_max/r_min);
v_A=R*sqrt(g/a)*sqrt(r_min/r_max);
v_C^2=2*g*R^2*((1/r)-(1/(2*a)));
tau=(2*pi)*(a^(3/2)/(R*sqrt(g)));
end Ex3_31;
