class Ex4_3
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=20;/*mass of the ahell*/
parameter Real v_mag(unit="m/s")=300;/*magnitude of the velocity of the shell*/ 
Real v[3](each unit="m/s");/*initial velocity of the shell*/
Real v_P[3](each unit="m/s");/*velocity of the shell at P*/
Real t(unit="s");/*time required to reach at P*/
Real h(unit="m");/*maximum height achieved by shell*/

parameter Real m_A(unit="kg")=5;/*mass of the part A*/
parameter Real h_A(unit="m")=500;/*height achieved by part A in z-direction*/
Real v_A_mag(unit="m/s");/*magnitude of the velocity of the part A*/ 
Real v_A[3](each unit="m/s");/*velocity of the part A*/

parameter Real s(unit="m")=4000;/*distance travelles by part B after explosion*/
parameter Real m_B(unit="kg")=9;/*mass of the part B*/
parameter Real alpha_B_deg(unit="deg")=45;/*direction of the part B w.r.t. x-axis in degree unit*/
Real alpha_B(unit="rad");/*direction of the part B w.r.t. x-axis in radian unit*/
Real v_B_mag(unit="m/s");/*magnitude of the velocity of the part B*/ 
Real v_B[3](each unit="m/s");/*velocity of the part B*/

parameter Real m_C(unit="kg")=6;/*mass of the part C*/
Real v_C[3](each unit="m/s");/*velocity of the part C*/
Real v_C_mag(unit="m/s");/*magnitude of the velocity of the part C*/
equation
v={v_mag*(3/5),0,v_mag*(4/5)};
t=v[3]/g;
h=v[3]^2/(2*g);

v_A_mag=sqrt(2*g*h_A);
v_A={0,0,v_A_mag};

alpha_B=Modelica.SIunits.Conversions.from_deg(alpha_B_deg);
v_B_mag=s/t;
v_B={v_B_mag*cos(alpha_B),v_B_mag*sin(alpha_B),0};

v_P={v[1],0,0};
m*v_P=m_A*v_A+m_B*v_B+m_C*v_C;
v_C_mag=Modelica.Math.Vectors.norm(v_C);
/*The  answer may slightly vary due to  rounding off values*/
end Ex4_3;
