class Ex4_4
parameter Real pi = Modelica.Constants.pi;

parameter Real m_carriage(unit="kg")=16;/*mass of the carriage*/
parameter Real m_ball(unit="kg")=1.6;/*mass of the each ball*/
parameter Real v(unit="m/s")=1.2;/*velocity of the carriage*/

parameter Real r_12(unit="mm")=450;/*distance between O and ball 1 and 2*/
parameter Real w_12(unit="rev/min")=80;/*roational velocity of the ball 1 and 2*/
Real v_rel_12(unit="m/s");/*velocity of the ball 1 and 2 w.r.t O*/ 

parameter Real r_34(unit="mm")=300;/*distance between O and ball 3 and 4*/
parameter Real w_34(unit="rev/min")=100;/*roational velocity of the ball 3 and 4*/
Real v_rel_34(unit="m/s");/*velocity of the ball 3 and 4 w.r.t O*/ 

Real T_tran(unit="J");/*translation kinetic energy of the system*/
Real T_rota(unit="J");/*rotational kinetic energy of the system*/
Real T(unit="J");/*total kinetic energy of the system*/
Real G(unit="kg.m/s");/*linear momentum of the system*/
Real H_O(unit="kg.m^2/s");/*angular momentum of the system*/
equation
v_rel_12=(r_12/1000)*w_12*((2*pi)/60);/*here r_12 is divided by 1000 to convert unit from mm to m and also w_12 is multiplied by ((2*pi)/60) convert unit from rev/min to rad/s */
v_rel_34=(r_34/1000)*w_34*((2*pi)/60);/*here r_34 is divided by 1000 to convert unit from mm to m and also w_34 is multiplied by ((2*pi)/60) convert unit from rev/min to rad/s */
T_tran=(1/2)*(m_carriage+4*m_ball)*v^2;

T_rota=2*(1/2)*m_ball*v_rel_12^2+2*(1/2)*m_ball*v_rel_34^2;
T=T_tran+T_rota;

G=(m_carriage+4*m_ball)*v;
H_O=2*m_ball*(r_12/1000)*v_rel_12-2*m_ball*(r_34/1000)*v_rel_34;

end Ex4_4;
