class Ex5_2
parameter Real r_C(unit="m")=(800/2)/1000;/*distance bentween center of the drum and point C*/
parameter Real r_B(unit="m")=(600/2)/1000;/*distance bentween center of the drum and point B*/
parameter Real r_A(unit="m")=(200/2)/1000;/*radius of the pinion A*/
parameter Real s(unit="m")=0.8;/*displacement of the load*/
parameter Real v(unit="m/s")=2;/*velocity of the load*/

Real a(unit="m/s^2");/*acceleration of the load*/
Real a_t(unit="m/s^2");/*tangential acceleration of point C*/
Real a_n(unit="m/s^2");/*normal acceleration of point C*/
Real a_C(unit="m/s^2");/*total acceleration of point C*/

Real w_B(unit="rad/s");/*angular velocity of point B*/
Real alpha_B(unit="rad/s^2");/*angular acceleration of point B*/

Real w_A(unit="rad/s");/*angular velocity of pinion A*/
Real alpha_A(unit="rad/s^2");/*angular acceleration of pinion A*/

equation
a=v^2/(2*s);
a_t=a;
a_n=v^2/r_C;
a_C=sqrt(a_t^2+a_n^2);

w_B=v/r_C;
alpha_B=a_t/r_C;

r_A*w_A=r_B*w_B;
r_A*alpha_A=r_B*alpha_B;
end Ex5_2;
