class Ex6_10
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=20;/*mass of the bar*/

parameter Real AB(unit="m")=600/1000;/*length of AB*/
parameter Real BD(unit="m")=600/1000;/*length of BD*/
parameter Real L_0(unit="m")=450/1000;/*initial distance between bar and spring*/

parameter Real theta_deg(unit="deg")=30;/*angle between AB and vertical path in degree unit at state 2*/
Real theta(unit="rad");/*angle between AB and vertical path in radian unit at state 2*/

Real w(unit="rad/s");/*angular velocity of the bar*/

Real U_12_das(unit="J");/*work done on the bar*/
Real CB_bar(unit="m");/*instantaneous center*/
Real T1(unit="J");/*initial kinetic energy of the bar*/
Real T2(unit="J");/*kinetic energy of the bar at 30^o position*/
Real V1(unit="J");/*initial gravitational potential energy*/
Real V2(unit="J");/*final gravitational potential energy*/

parameter Real k(unit="N/m")=5*10^3;/*stiffness of the spring*/
Real V_e1(unit="J");/*initial spring potential energy*/
Real V_e2(unit="J");/*final spring potential energy*/
Real V3(unit="J");/*final gravitational potential energy*/

Real T3(unit="J");/*final kinetic energy*/
Real v_B(unit="m/s");/*velocity at point B*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
CB_bar=AB*sin(theta);
U_12_das=0;
T1=0;
T2=(1/2)*m*(CB_bar*w)^2+(1/2)*(1/12)*(m*(AB+BD)^2)*w^2;
V1=0;
V2=m*g*(AB*cos(theta)-AB);
T1+V1+U_12_das=T2+V2;
V_e1=0;
V_e2=(1/2)*k*(AB-L_0)^2;
T3=(1/2)*(1/3)*m*(AB+BD)^2*(v_B/AB)^2;
V3=m*g*(-AB);
T1+V_e1=T3+V3;
/*The  answer provided for v_B in the textbook is wrong*/
end Ex6_10;
