class Ex6_3
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_block(unit="kg")=300;/*mass of the concrete block*/
parameter Real m_drum(unit="kg")=150;/*mass of the drum*/

parameter Real r_s(unit="m")=300/1000;/*radius of the small drum*/
parameter Real r_b(unit="m")=600/1000;/*radius of the big drum*/
parameter Real k_o(unit="m")=450/1000;/*radius of giration of the drum*/

parameter Real theta_deg(unit="deg")=45;/*angle betwen force P and axis-x in degree unit*/
Real theta(unit="rad");/*angle betwen force P and axis-x in radian unit*/

parameter Real P(unit="N")=1.8*10^3;/*tension by the power unit*/

Real I_O(unit="kg.m^2");/*moment of inertia of the drum*/
Real T(unit="N");/*tension in the cable connected with the block*/
Real alpha(unit="rad/s^2");/*angular acceleration*/

Real a(unit="m/s^2");/*acceleration of the bock*/
Real O_x(unit="N");/*x-componet of the resultant force on the bearing at O*/
Real O_y(unit="N");/*y-componet of the resultant force on the bearing at O*/
Real O(unit="N");/*resultant force on the bearing at O*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
I_O=k_o^2*m_drum;
P*r_b-T*r_s=I_O*alpha;
T-m_block*g=m_block*a;
a=r_s*alpha;

O_x-P*cos(theta)=0;
O_y-m_drum*g-T-P*sin(theta)=0;
O=sqrt(O_x^2+O_y^2);
/*The  answer may slightly vary due to  rounding off values*/


end Ex6_3;
