class Ex6_6
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_B(unit="kg")=70;/*mass of B*/

parameter Real r_A(unit="m")=250/1000;/*radius of A*/
parameter Real r_B(unit="m")=450/1000;/*radius of B*/
parameter Real r(unit="m")=150/1000;/*radius of inner wheel*/
parameter Real k_bar(unit="m")=250/1000;/*radius of giration of B*/

parameter Real alpha(unit="rad/s^2")=3;/*angular acceleration of A*/
Real alpha_counter(unit="rad/s^2");/*counterclockwise angular acceleration*/

Real a_bar(unit="m/s^2");/*acceleration of the mass center G*/
Real a_t(unit="m/s^2");/*acceleration of the connecting cable*/

Real N(unit="N");/*normal force on the B*/
Real T(unit="N");/*tension in the cable*/
Real F(unit="N");/*frictional force*/
equation
a_t=r_A*alpha;
alpha_counter=a_t/(r_B-r);
a_bar=r_B*alpha_counter;

F-T=m_B*(-a_bar);
N-m_B*g=0;
F*r_B-T*r=m_B*k_bar^2*alpha_counter;
/*The  answer may slightly vary due to  rounding off values*/
end Ex6_6;
