class Ex7_3
parameter Real w1(unit="rad/s")=6;/*angular velocity of crank AB*/
parameter Real AD(unit="mm")=50;/*length of AD*/
parameter Real BC(unit="mm")=100;/*length of BC*/
parameter Real BY(unit="mm")=100;/*length of BY*/

Real w2(unit="rad/s");/*angular velocity of crank DA*/

Real w_n[3](each unit="rad/s");/*angular velocity of link AB*/
Real w_n_mag(unit="rad/s");/*magnitude of angular velocity of link AB*/
Real w_nx(unit="rad/s");/*x-component of angular velocity of link AB*/
Real w_ny(unit="rad/s");/*y-component of angular velocity of link AB*/
Real w_nz(unit="rad/s");/*z-component of angular velocity of link AB*/

Real v_A[3](each unit="mm/s");/*velocity of A*/
Real v_B[3](each unit="mm/s");/*velocity of B*/

Real v_A_R[3](each unit="mm/s");/*right side of relative velocity equation*/

parameter Real r_AB[3](each unit="mm")={50,100,100};/*position of A w.r.t B*/

equation
w_n={w_nx,w_nz,w_ny};
v_A={0,AD*w2,0};
v_B={BC*w1,0,0};

v_A_R=v_B+cross(w_n,r_AB);

v_A[1]=v_A_R[1];
v_A[2]=v_A_R[2];
v_A[3]=v_A_R[3];

sum(w_n.*r_AB)=0;
w_n_mag=Modelica.Math.Vectors.norm(w_n);

/*The  answer provided for vector form of w_n in the textbook is wrong*/
end Ex7_3;
