class Ex7_6
parameter Real L_A(unit="m")=125/1000;/*length of plate of A*/
parameter Real W_A(unit="m")=100/1000;/*width of plate of A*/
parameter Real L_B(unit="m")=150/1000;/*length of plate of B*/
parameter Real W_B(unit="m")=75/1000;/*width of plate of B*/
parameter Real m_area(unit="kg/m^2")=70;/*mass per unit area*/
Real m_A(unit="kg");/*mass of plate A*/
Real m_B(unit="kg");/*mass of plate B*/
parameter Real w_z(unit="rad/s")=30;/*component of angular velocity of the plate about z-axis*/
Real w[3](each unit="rad/s");/*angular velocity of the plate*/

Real I_xx_A(unit="kg.m^2");/*moment of inertia about x-axis of plate A*/
Real I_yy_A(unit="kg.m^2");/*moment of inertia about y-axis of plate A*/
Real I_zz_A(unit="kg.m^2");/*moment of inertia about z-axis of plate A*/
Real I_xy_A(unit="kg.m^2");/*product of inertia of plate A*/
Real I_yz_A(unit="kg.m^2");/*product of inertia of plate A*/
Real I_zx_A(unit="kg.m^2");/*product of inertia of plate A*/

Real I_xx_B(unit="kg.m^2");/*moment of inertia about x-axis of plate B*/
Real I_yy_B(unit="kg.m^2");/*moment of inertia about y-axis of plate B*/
Real I_zz_B(unit="kg.m^2");/*moment of inertia about z-axis of plate B*/
Real I_xy_B(unit="kg.m^2");/*product of inertia of plate B*/
Real I_yz_B(unit="kg.m^2");/*product of inertia of plate B*/
Real I_zx_B(unit="kg.m^2");/*product of inertia of plate B*/

Real I_xx(unit="kg.m^2");/*moment of inertia about x-axis of the plate*/
Real I_yy(unit="kg.m^2");/*moment of inertia about y-axis of the plate*/
Real I_zz(unit="kg.m^2");/*moment of inertia about z-axis of the plate*/
Real I_xy(unit="kg.m^2");/*product of inertia of the plate*/
Real I_yz(unit="kg.m^2");/*product of inertia of the plate*/
Real I_zx(unit="kg.m^2");/*product of inertia of the plate*/
 
Real H[3](each unit="N.m.s");/*angular momentum of the plate*/
Real T(unit="J");/*kinetic energy of the plate*/
equation
m_A=L_A*W_A*m_area;
m_B=L_B*W_B*m_area;
w={0,0,w_z};
I_xx_A=(m_A/12)*(W_A^2+L_A^2)+m_A;
end Ex7_6;
