class Ex8_1
parameter Real pi = Modelica.Constants.pi;

parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=10;/*mass of the body*/
parameter Real k(unit="N/m")=2.5*10^3;/*stiffness of the spring*/
parameter Real x_0(unit="m")=0;/*initial displacement*/
parameter Real x_0_dot(unit="m/s")=0.5;/*downword velocity of the body at t=0 s*/

Real del_st(unit="m");/*static spring deflection*/
Real w_n(unit="rad/s");/*natural frequency in rad/s*/
Real f_n(unit="cycle/s");/*natural frequency in cycle/s*/
Real x(unit="m");/*displacement as a function of time*/
Real v(unit="m/s");/*velocity of the body*/
Real v_max(unit="m/s");/*maximum velocity*/
Real a(unit="m/s^2");/*acceleration of the body*/
Real a_max(unit="m/s^2");/*maximum acceleration*/

equation
del_st=(m*g)/k;
w_n=sqrt(k/m);
f_n=w_n*(1/(2*pi));
x=x_0*cos(w_n*time)+(x_0_dot/w_n)*sin(w_n*time);
v=der(x);
v_max = max(v, pre(v_max));
a=der(v);
a_max = max(a, pre(a_max));
end Ex8_1;
