class Ex8_6
parameter Real m(unit="kg")=45;/*mass of the piston*/
parameter Real k(unit="N/m")=35*10^3;/*stiffness of the spring*/
parameter Real c(unit="N.s/m")=1250;/*damping coefficient*/

Real p(unit="Pa");/*pressure on the piston*/
parameter Real A(unit="m^2")=50*10^(-3);/*top surface area of the piston*/

Real w_n(unit="rad/s");/*natural frequency */
Real eta;/*damping ratio*/
Real F_0(unit="N");/*force amlitude*/
Real w(unit="rad/s");/*impressed frequency */

Real X(unit="m");/*stady state amplitude*/
Real psi(unit="rad");/*phase angle*/

Real x_p(unit="m");/*stady state displacement as a function of time*/
Real F_tr(unit="N");/*force transmitted to the base*/
Real F_tr_max(unit="N");/*maximum force transmitted to the base*/
equation
p=4000*sin(30*time);
w=30;
w_n=sqrt(k/m);
eta=c/(2*m*w_n);
F_0=4000*A;
X=(F_0/k)/sqrt((1-(w/w_n)^2)^2+(2*eta*(w/w_n))^2);
psi=atan2((2*eta*(w/w_n)),(1-(w/w_n)^2));
x_p=X*sin(w*time-psi);
F_tr=k*x_p+c*der(x_p);
F_tr_max=sqrt((k*X)^2+(c*w*X)^2);
end Ex8_6;
