class Ex8_7
parameter Real pi = Modelica.Constants.pi;

parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real r_bar(unit="m")=0.9;/*center of mass*/
parameter Real k_o(unit="m")=0.95;/*radius of gyration*/

Real f(unit="cycle/s");/*frequency in cycle per second*/
Real tau(unit="s");/*period of pendulum*/
equation
f=(1/(2*pi))*sqrt((g*r_bar)/k_o^2);
tau=1/f;
end Ex8_7;
