class Ex8_9
parameter Real pi = Modelica.Constants.pi;

parameter Real m(unit="kg")=50;/*mass of the cylinder*/
parameter Real k(unit="N/m")=75;/*stiffness of the spring*/
parameter Real c(unit="N.s/m")=10;/*damping coefficient*/
parameter Real r(unit="m")=0.5;/*radius of the cylinder*/

Real w_n(unit="rad/s");/*natural frequency */
Real eta;/*damping ratio*/
Real w_d(unit="rad/s");/*damped natural frequency */
Real tau_d(unit="s");/*period of the damped system*/

equation
w_n=sqrt((2/3)*(k/m));
eta=c/(3*m*w_n);
w_d=w_n*sqrt(1-eta^2);
tau_d=(2*pi)/w_d;
end Ex8_9;
