class Ex3_14
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=360;/*mass of the log*/
parameter Real v(unit="m/s")=1.2;/*velocity of the log*/

Real mu_k;/*coefficient of kinetic friction*/
parameter Real alpha_deg(unit="deg")=30;/*elevation angle of the ramp in degree unit*/
Real alpha(unit="deg");/*elevation angle of the ramp in radian unit*/

Real T1(unit="N");/*tension in the cable*/
Real N(unit="N");/*normal force on the crete*/
parameter Real P1(unit="W")=4*10^3;/*power output of the winch*/
parameter Real P2(unit="W")=6*10^3;/*increased power output of the winch*/
Real T2(unit="N");/*tension in the cable*/
Real a(unit="m/s^2");/*acceleration of the block*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
N=m*g*cos(alpha);
T1-N*mu_k-m*g*sin(alpha)=0;
P1=T1*v;
P2=T2*v;
T2-N*mu_k-m*g*sin(alpha)=m*a;
end Ex3_14;
