class Ex3_15
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real R(unit="m")=6371*10^3;/*radius of the earth*/

parameter Real h1(unit="m")=500*10^3;/*altitude of position A from the earth surface*/
parameter Real h2(unit="m")=1200*10^3;/*altitude of position B from the earth surface*/
Real r1(unit="m");/*distance between posion A and center of the earth*/
Real r2(unit="m");/*distance between posion B and center of the earth*/

parameter Real v1_kmph(unit="km/h")=30000;/*velocity of the satellite at position A in km per hour unit*/
Real v1(unit="m/s");/*velocity of the satellite at position A in m/s unit*/
Real v2(unit="m/s");/*velocity of the satellite at position B*/

equation
r1=h1+R;
r2=h2+R;
v1=v1_kmph*(1000/3600);
v2^2=v1^2+2*g*R^2*(1/r2-1/r1);
end Ex3_15;
