class Ex3_18
/*Number-A*/
parameter Real pi = Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_A(unit="kg")=2;/*mass of the the ball-A*/
parameter Real m_B(unit="kg")=4;/*mass of the the bar-A*/
parameter Real L(unit="m")=0.5;/*length of the slender bar-OA*/
parameter Real k_theta(unit="N.m/rad")=13;/*tortional stiffness of the spring*/

Real v_A_90(start=0.01,unit="m/s");/*velocity of the ball-A at 90 degree*/
Real v_B_90(unit="m/s");/*velocity of the bar-B at 90 degree*/

equation
v_B_90=((1/4)*v_A_90);
(1/2)*m_A*v_A_90^2+(1/2)*m_B*v_B_90^2-m_A*g*L-m_B*g*((L*sqrt(2))/4)+(1/2)*k_theta*(pi/2)^2=0;

end Ex3_18;
