class Ex3_23
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m_bu(unit="kg")=50/1000;/*mass of the the bullet*/
parameter Real m_bl(unit="kg")=4;/*mass of the the blpock*/
parameter Real v_bu[2](each unit="m/s")={0,600};/*velocity of the bullet*/
Real v_bl[2](each unit="m/s");/*velocity of the block*/
parameter Real v_bl_mag(unit="m/s")=12;/*magnitude of the velocity of the block*/

parameter Real alpha_deg(unit="deg")=30;/*direction of the block w.r.t. x-axis in degree unit*/
Real alpha(unit="rad");/*direction of the block w.r.t. x-axis in radian unit*/
Real v2[2](each unit="m/s");/*velocity of the system*/
Real v2_mag(unit="m/s");/*magnitude of the velocity of the system*/
Real theta(unit="rad");/*direction of the system w.r.t. x-axis in radian unit*/
Real theta_deg(unit="deg");/*direction of the block w.r.t. x-axis in degree unit*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
v_bl={v_bl_mag*cos(alpha),v_bl_mag*sin(alpha)} ;
m_bu*v_bu+m_bl*v_bl=(m_bu+m_bl)*v2;
v2_mag=Modelica.Math.Vectors.norm(v2);
tan(theta)=v2[2]/v2[1];
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);
end Ex3_23;
