class Ex3_28
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m_ram(unit="kg")=800;/*mass of the ram*/
parameter Real m_pile(unit="kg")=2400;/*mass of the pile*/
parameter Real r1(unit="m")=2;/*distance between ram and pile*/
parameter Real r2(unit="m")=0.1;
Real v_r(unit="m/s");/*initial velocity of the ram*/
Real v_r_das(unit="m/s");/*final velocity of the ram*/
Real v_p_das(unit="m/s");/*velocity of the pile immediately after the impact*/
Real e;/*coefficient of restitution*/
Real T(unit="J");/*kinetic energy of the system just before the impact*/
Real V_g(unit="J");/*potential energy of the ram above the pile*/
Real T_das(unit="J");/*kinetic energy of the system just after the impact*/
Real E_loss(unit="%");/*percentage loss of energy due to impact*/
equation
v_r=sqrt(2*g*r1);
v_r_das=sqrt(2*g*r2);
m_ram*v_r=m_ram*(-v_r_das)+m_pile*v_p_das;
e=(v_p_das+v_r_das)/(v_r+0);
V_g=m_ram*g*r1;
T=V_g;
T_das=(1/2)*m_ram*v_r_das^2+(1/2)*m_pile*v_p_das^2;
E_loss=((T-T_das)/T)*100;
end Ex3_28;
