class Ex3_3
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_A(unit="kg")=125;/*mass of the concrete block A*/
parameter Real m_log(unit="kg")=200;/*mass of the log*/

parameter Real alpha_deg(unit="deg")=30;/*elevation angle of the ramp in degree unit*/
Real alpha(unit="rad");/*elevation angle of the ramp in radian unit*/
parameter Real mu=0.5;/*coefficient of kenetic friction between the log and the ramp*/

Real a_C(unit="m/s^2");/*acceleration of the log*/
Real a_A(unit="m/s^2");/*acceleration of the block A*/

Real N(unit="N");/*normal force on the log*/
Real T(unit="N");/*tension in the cable*/

parameter Real x(unit="m")=6;/*distance between block A and ground*/
Real v_A(unit="m/s");/*velocity of the block A*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
0=2*a_C+a_A;
N-m_log*g*cos(alpha)=0;
mu*N-2*T+m_log*g*sin(alpha)=m_log*a_C;
m_A*g-T=m_A*a_A;
v_A=sqrt(2*a_A*x);
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_3;
