class Ex3_8
parameter Real m(unit="kg")=1500;/*mass of the car*/

parameter Real v_A_kmph(unit="km/h")=100;/*velocity at point A in km/h unit*/
Real v_A(unit="m/s");/*velocity at point A in m/s unit*/
parameter Real v_C_kmph(unit="km/h")=50;/*velocity at point C in km/h unit*/
Real v_C(unit="m/s");/*velocity at point C in m/s unit*/

parameter Real ds(unit="m")=200;/*distance from A to C*/ 
Real a_t(unit="m/s^2");/*constant deceleration along the path*/
Real F_t(unit="N");/*tangential force along the path*/

Real a_nA(unit="m/s^2");/*normal component of acceleration at point A*/
parameter Real rho_A(unit="m")=400;/*radius of curvature at point A*/
Real F_nA(unit="N");/*normal force at point A*/
Real F_A(unit="N");/*total horizontal force at point A*/

Real a_nB(unit="m/s^2");/*normal component of acceleration at point B*/
Real F_nB(unit="N");/*normal force at point A*/
Real F_B(unit="N");/*total horizontal force at point B*/

parameter Real rho_C(unit="m")=80;/*radius of curvature at point C*/
Real a_nC(unit="m/s^2");/*normal component of acceleration at point C*/
Real F_nC(unit="N");/*normal force at point A*/ 
Real F_C(unit="N");/*total horizontal force at point C*/

equation
v_A=v_A_kmph*(1000/3600);
v_C=v_C_kmph*(1000/3600);

a_t=abs((1/(2*ds))*(v_C^2-v_A^2));
F_t=m*a_t;

a_nA=v_A^2/rho_A;
F_nA=m*a_nA;
F_A=sqrt(F_nA^2+F_t^2);

a_nB=0;
F_nB=m*a_nB;
F_B=sqrt(F_nB^2+F_t^2);

a_nC=v_C^2/rho_C;
F_nC=m*a_nC;
F_C=sqrt(F_nC^2+F_t^2);

/*The  answer may slightly vary due to  rounding off values*/

end Ex3_8;
