class Ex5_11
parameter Real r(unit="m")=300/1000;/*radius of the wheel*/
parameter Real v_O(unit="m/s")=3;/*velocity of the wheel*/
parameter Real r_O(unit="m/s")=200/1000;/*position  of the point A*/
parameter Real alpha_A_deg(unit="deg")=120;/*angle between CO and OA in degree unit*/
Real alpha_A(unit="rad");/*angle between CO and OA in radian unit*/

Real w(unit="rad/s");/*angular velocity of the wheel*/
Real AC(unit="m");/*distance from A to C*/
Real v_A(unit="m/s");/*velocity of the point A*/
equation
alpha_A=Modelica.SIunits.Conversions.from_deg(alpha_A_deg);

w=v_O/r;
AC=sqrt(r^2+r_O^2-2*r*r_O*cos(alpha_A));
v_A=AC*w;

end Ex5_11;
