class Ex5_12
parameter Real theta_deg(unit="deg")=120;/*angle between O_dasO and Ob in degree unit*/
Real theta(unit="rad");/*angle between O_dasO and Ob in radian unit*/
parameter Real OB(unit="m")=(150*sqrt(2))/1000;/*length of OB*/
parameter Real BD(unit="m")=200/1000;/*length of BD*/
parameter Real AD(unit="m")=150/1000;/*length of AD*/
parameter Real O_dasA(unit="m")=1500/1000;/*length of O_dasA*/

parameter Real w_OB(unit="rad/s")=10;/*angular velocity of OB*/

parameter Real BC(unit="m")=(350*sqrt(2))/1000;/*length of BC*/
parameter Real DC(unit="m")=381/1000;/*length of DC*/
parameter Real AC(unit="m")=350/1000;/*length of AC*/

Real w_BC(unit="rad/s");/*angular velocity of BC*/

Real v_A(unit="m/s");/*velocity of the point A*/
Real v_D(unit="m/s");/*velocity of the point D*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
w_BC=(OB*w_OB)/BC;
v_A=AC*w_BC;
v_D=DC*w_BC;
end Ex5_12;
